/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.sl.usermodel.Placeholder;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.util.Internal;
import org.apache.poi.xslf.model.PropertyFetcher;
import org.apache.poi.xslf.usermodel.XSLFColor;
import org.apache.poi.xslf.usermodel.XSLFPropertiesDelegate;
import org.apache.poi.xslf.usermodel.XSLFShapeContainer;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlip;
import org.openxmlformats.schemas.drawingml.x2006.main.CTBlipFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGradientStop;
import org.openxmlformats.schemas.drawingml.x2006.main.CTGroupShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTNonVisualDrawingProps;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTShapeStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrix;
import org.openxmlformats.schemas.drawingml.x2006.main.CTStyleMatrixReference;
import org.openxmlformats.schemas.drawingml.x2006.main.STPathShadeType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTApplicationNonVisualDrawingProps;
import org.openxmlformats.schemas.presentationml.x2006.main.CTBackgroundProperties;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.STPlaceholderType;

public abstract class XSLFShape
implements Shape<XSLFShape, XSLFTextParagraph> {
    protected static final String PML_NS = "http://schemas.openxmlformats.org/presentationml/2006/main";
    private final XmlObject _shape;
    private final XSLFSheet _sheet;
    private XSLFShapeContainer _parent;
    private CTShapeStyle _spStyle;
    private CTNonVisualDrawingProps _nvPr;
    private CTPlaceholder _ph;

    protected XSLFShape(XmlObject shape, XSLFSheet sheet) {
        this._shape = shape;
        this._sheet = sheet;
    }

    public final XmlObject getXmlObject() {
        return this._shape;
    }

    public XSLFSheet getSheet() {
        return this._sheet;
    }

    public String getShapeName() {
        return this.getCNvPr().getName();
    }

    public int getShapeId() {
        return (int)this.getCNvPr().getId();
    }

    @Internal
    void copy(XSLFShape sh) {
        if (!this.getClass().isInstance(sh)) {
            throw new IllegalArgumentException("Can't copy " + sh.getClass().getSimpleName() + " into " + this.getClass().getSimpleName());
        }
        if (this instanceof PlaceableShape) {
            PlaceableShape ps = (PlaceableShape)((Object)this);
            ps.setAnchor(sh.getAnchor());
        }
    }

    public void setParent(XSLFShapeContainer parent) {
        this._parent = parent;
    }

    public XSLFShapeContainer getParent() {
        return this._parent;
    }

    protected PaintStyle getFillPaint() {
        final XSLFTheme theme = this.getSheet().getTheme();
        final boolean hasPlaceholder = this.getPlaceholder() != null;
        PropertyFetcher<PaintStyle> fetcher = new PropertyFetcher<PaintStyle>(){

            @Override
            public boolean fetch(XSLFShape shape) {
                XSLFPropertiesDelegate.XSLFFillProperties fp = XSLFPropertiesDelegate.getFillDelegate(shape.getShapeProperties());
                if (fp == null) {
                    return false;
                }
                if (fp.isSetNoFill()) {
                    this.setValue(null);
                    return true;
                }
                PackagePart pp = shape.getSheet().getPackagePart();
                PaintStyle paint = XSLFShape.selectPaint(fp, null, pp, theme, hasPlaceholder);
                if (paint != null) {
                    this.setValue(paint);
                    return true;
                }
                CTShapeStyle style = shape.getSpStyle();
                if (style != null) {
                    fp = XSLFPropertiesDelegate.getFillDelegate(style.getFillRef());
                    paint = XSLFShape.selectPaint(fp, null, pp, theme, hasPlaceholder);
                }
                if (paint != null) {
                    this.setValue(paint);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return (PaintStyle)fetcher.getValue();
    }

    protected CTBackgroundProperties getBgPr() {
        return this.getChild(CTBackgroundProperties.class, PML_NS, "bgPr");
    }

    protected CTStyleMatrixReference getBgRef() {
        return this.getChild(CTStyleMatrixReference.class, PML_NS, "bgRef");
    }

    protected CTGroupShapeProperties getGrpSpPr() {
        return this.getChild(CTGroupShapeProperties.class, PML_NS, "grpSpPr");
    }

    protected CTNonVisualDrawingProps getCNvPr() {
        if (this._nvPr == null) {
            String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:cNvPr";
            this._nvPr = this.selectProperty(CTNonVisualDrawingProps.class, xquery);
        }
        return this._nvPr;
    }

    protected CTShapeStyle getSpStyle() {
        if (this._spStyle == null) {
            this._spStyle = this.getChild(CTShapeStyle.class, PML_NS, "style");
        }
        return this._spStyle;
    }

    protected <T extends XmlObject> T getChild(Class<T> childClass, String namespace, String nodename) {
        XmlCursor cur = this.getXmlObject().newCursor();
        XmlObject child = null;
        if (cur.toChild(namespace, nodename)) {
            child = cur.getObject();
        }
        if (cur.toChild("http://schemas.openxmlformats.org/drawingml/2006/main", nodename)) {
            child = cur.getObject();
        }
        cur.dispose();
        return (T)child;
    }

    protected CTPlaceholder getCTPlaceholder() {
        if (this._ph == null) {
            String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:nvPr/p:ph";
            this._ph = this.selectProperty(CTPlaceholder.class, xquery);
        }
        return this._ph;
    }

    public Placeholder getPlaceholder() {
        CTPlaceholder ph = this.getCTPlaceholder();
        if (ph == null || !ph.isSetType() && !ph.isSetIdx()) {
            return null;
        }
        return Placeholder.lookupOoxml(ph.getType().intValue());
    }

    protected void setPlaceholder(Placeholder placeholder) {
        String xquery = "declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:nvPr";
        CTApplicationNonVisualDrawingProps nv = this.selectProperty(CTApplicationNonVisualDrawingProps.class, xquery);
        if (nv == null) {
            return;
        }
        if (placeholder == null) {
            if (nv.isSetPh()) {
                nv.unsetPh();
            }
            this._ph = null;
        } else {
            nv.addNewPh().setType(STPlaceholderType.Enum.forInt(placeholder.ooxmlId));
        }
    }

    protected <T extends XmlObject> T selectProperty(Class<T> resultClass, String xquery) {
        XmlObject[] rs = this.getXmlObject().selectPath(xquery);
        if (rs.length == 0) {
            return null;
        }
        return (T)(resultClass.isInstance(rs[0]) ? rs[0] : null);
    }

    protected boolean fetchShapeProperty(PropertyFetcher<?> visitor) {
        int textType;
        XSLFSlideMaster master;
        XSLFSimpleShape masterShape;
        if (visitor.fetch(this)) {
            return true;
        }
        CTPlaceholder ph = this.getCTPlaceholder();
        if (ph == null) {
            return false;
        }
        XSLFSlideMaster sm = this.getSheet().getMasterSheet();
        if (sm instanceof XSLFSlideLayout) {
            XSLFSlideLayout slideLayout = (XSLFSlideLayout)((Object)sm);
            XSLFSimpleShape placeholderShape = slideLayout.getPlaceholder(ph);
            if (placeholderShape != null && visitor.fetch(placeholderShape)) {
                return true;
            }
            sm = slideLayout.getMasterSheet();
        }
        return sm instanceof XSLFSlideMaster && (masterShape = (master = (XSLFSlideMaster)sm).getPlaceholderByType(textType = XSLFShape.getPlaceholderType(ph))) != null && visitor.fetch(masterShape);
    }

    private static int getPlaceholderType(CTPlaceholder ph) {
        if (!ph.isSetType()) {
            return 2;
        }
        switch (ph.getType().intValue()) {
            case 1: 
            case 3: {
                return 1;
            }
            case 5: 
            case 6: 
            case 7: {
                return ph.getType().intValue();
            }
        }
        return 2;
    }

    protected static PaintStyle selectPaint(XSLFPropertiesDelegate.XSLFFillProperties fp, CTSchemeColor phClr, PackagePart parentPart, XSLFTheme theme, boolean hasPlaceholder) {
        if (fp == null || fp.isSetNoFill()) {
            return null;
        }
        if (fp.isSetSolidFill()) {
            return XSLFShape.selectPaint(fp.getSolidFill(), phClr, theme);
        }
        if (fp.isSetBlipFill()) {
            return XSLFShape.selectPaint(fp.getBlipFill(), parentPart);
        }
        if (fp.isSetGradFill()) {
            return XSLFShape.selectPaint(fp.getGradFill(), phClr, theme);
        }
        if (fp.isSetMatrixStyle()) {
            return XSLFShape.selectPaint(fp.getMatrixStyle(), theme, fp.isLineStyle(), hasPlaceholder);
        }
        return null;
    }

    protected static PaintStyle selectPaint(CTSolidColorFillProperties solidFill, CTSchemeColor phClr, XSLFTheme theme) {
        if (solidFill.isSetSchemeClr() && phClr == null) {
            phClr = solidFill.getSchemeClr();
        }
        XSLFColor c = new XSLFColor(solidFill, theme, phClr);
        return DrawPaint.createSolidPaint(c.getColorStyle());
    }

    protected static PaintStyle selectPaint(CTBlipFillProperties blipFill, final PackagePart parentPart) {
        final CTBlip blip = blipFill.getBlip();
        return new PaintStyle.TexturePaint(){

            private PackagePart getPart() {
                try {
                    String blipId = blip.getEmbed();
                    PackageRelationship rel = parentPart.getRelationship(blipId);
                    return parentPart.getRelatedPart(rel);
                }
                catch (InvalidFormatException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public InputStream getImageData() {
                try {
                    return this.getPart().getInputStream();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String getContentType() {
                return this.getPart().getContentType();
            }

            @Override
            public int getAlpha() {
                return blip.sizeOfAlphaModFixArray() > 0 ? blip.getAlphaModFixArray(0).getAmt() : 100000;
            }
        };
    }

    protected static PaintStyle selectPaint(final CTGradientFillProperties gradFill, CTSchemeColor phClr, XSLFTheme theme) {
        CTGradientStop[] gs = gradFill.getGsLst().getGsArray();
        Arrays.sort(gs, new Comparator<CTGradientStop>(){

            @Override
            public int compare(CTGradientStop o1, CTGradientStop o2) {
                Integer pos1 = o1.getPos();
                Integer pos2 = o2.getPos();
                return pos1.compareTo(pos2);
            }
        });
        final ColorStyle[] cs = new ColorStyle[gs.length];
        final float[] fractions = new float[gs.length];
        int i = 0;
        for (CTGradientStop cgs : gs) {
            CTSchemeColor phClrCgs = phClr;
            if (phClrCgs == null && cgs.isSetSchemeClr()) {
                phClrCgs = cgs.getSchemeClr();
            }
            cs[i] = new XSLFColor(cgs, theme, phClrCgs).getColorStyle();
            fractions[i] = (float)cgs.getPos() / 100000.0f;
            ++i;
        }
        return new PaintStyle.GradientPaint(){

            @Override
            public double getGradientAngle() {
                return gradFill.isSetLin() ? (double)gradFill.getLin().getAng() / 60000.0 : 0.0;
            }

            @Override
            public ColorStyle[] getGradientColors() {
                return cs;
            }

            @Override
            public float[] getGradientFractions() {
                return fractions;
            }

            @Override
            public boolean isRotatedWithShape() {
                return gradFill.getRotWithShape();
            }

            @Override
            public PaintStyle.GradientPaint.GradientType getGradientType() {
                if (gradFill.isSetLin()) {
                    return PaintStyle.GradientPaint.GradientType.linear;
                }
                if (gradFill.isSetPath()) {
                    STPathShadeType.Enum ps = gradFill.getPath().getPath();
                    if (ps == STPathShadeType.CIRCLE) {
                        return PaintStyle.GradientPaint.GradientType.circular;
                    }
                    if (ps == STPathShadeType.SHAPE) {
                        return PaintStyle.GradientPaint.GradientType.shape;
                    }
                }
                return PaintStyle.GradientPaint.GradientType.linear;
            }
        };
    }

    protected static PaintStyle selectPaint(CTStyleMatrixReference fillRef, XSLFTheme theme, boolean isLineStyle, boolean hasPlaceholder) {
        XmlObject styleLst;
        int childIdx;
        if (fillRef == null) {
            return null;
        }
        int idx = (int)fillRef.getIdx();
        CTStyleMatrix matrix = theme.getXmlObject().getThemeElements().getFmtScheme();
        if (idx >= 1 && idx <= 999) {
            childIdx = idx - 1;
            styleLst = isLineStyle ? matrix.getLnStyleLst() : matrix.getFillStyleLst();
        } else if (idx >= 1001) {
            childIdx = idx - 1001;
            styleLst = matrix.getBgFillStyleLst();
        } else {
            return null;
        }
        XmlCursor cur = styleLst.newCursor();
        XSLFPropertiesDelegate.XSLFFillProperties fp = null;
        if (cur.toChild(childIdx)) {
            fp = XSLFPropertiesDelegate.getFillDelegate(cur.getObject());
        }
        cur.dispose();
        CTSchemeColor phClr = fillRef.getSchemeClr();
        PaintStyle res = XSLFShape.selectPaint(fp, phClr, theme.getPackagePart(), theme, hasPlaceholder);
        if (res != null || hasPlaceholder) {
            return res;
        }
        XSLFColor col = new XSLFColor(fillRef, theme, phClr);
        return DrawPaint.createSolidPaint(col.getColorStyle());
    }

    @Override
    public void draw(Graphics2D graphics, Rectangle2D bounds) {
        DrawFactory.getInstance(graphics).drawShape(graphics, this, bounds);
    }

    protected XmlObject getShapeProperties() {
        return this.getChild(CTShapeProperties.class, PML_NS, "spPr");
    }
}

